<?php
$DB_HOST = 'localhost';
$DB_NAME = 'hiyorima_db';
$DB_USER = 'hiyorima_pengguna';
$DB_PASS = 'dRc9!1E5Eee]3Q';
$ADMIN_SECRET = 'hoki';
try {
    $pdo = new PDO("mysql:host=$DB_HOST;dbname=$DB_NAME;charset=utf8mb4", $DB_USER, $DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
} catch (Exception $e) { die('DB connection failed: '.$e->getMessage()); }
function rand_str($len=3){
    $chars = 'ABCDEFGHJKMNPQRSTUVWXYZ23456789';
    $s=''; for($i=0;$i<$len;$i++) $s .= $chars[random_int(0, strlen($chars)-1)];
    return $s;
}

// put somewhere near your other helper functions in scripts/db.php

if (!function_exists('generate_unique_code')) {
    // generate_unique_code($pdo, $length = 6, $prefix = '')
    function generate_unique_code($pdo, $length = 6, $prefix = '') {
        $chars = 'ABCDEFGHJKMNPQRSTUVWXYZ23456789';
        $tries = 0;
        do {
            $s = '';
            for ($i = 0; $i < max(1, $length - strlen($prefix)); $i++) {
                $s .= $chars[random_int(0, strlen($chars) - 1)];
            }
            $code = strtoupper($prefix . $s);
            // double-check not in DB
            $stmt = $pdo->prepare("SELECT id FROM order_codes WHERE code = ? LIMIT 1");
            $stmt->execute([$code]);
            $exists = (bool)$stmt->fetch();
            $tries++;
            if ($tries > 200) throw new Exception("Failed to generate unique code after many attempts");
        } while ($exists);
        return $code;
    }
}

if (!function_exists('check_and_consume_loyalty_sheet')) {
    // check_and_consume_loyalty_sheet($pdo, $user_id)
    function check_and_consume_loyalty_sheet($pdo, $user_id) {
        // count loyalty stamps that are not yet used_for_voucher
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM stamps WHERE user_id = ? AND type = 'loyalty' AND used_for_voucher = 0");
        $stmt->execute([$user_id]);
        $count = (int)$stmt->fetchColumn();
        if ($count < 10) return null;

        // mark the oldest 10 as used_for_voucher=1 and create voucher atomically
        $pdo->beginTransaction();
        try {
            $stmt = $pdo->prepare("SELECT id FROM stamps WHERE user_id = ? AND type = 'loyalty' AND used_for_voucher = 0 ORDER BY id ASC LIMIT 10");
            $stmt->execute([$user_id]);
            $ids = $stmt->fetchAll(PDO::FETCH_COLUMN);
            if (!$ids) { $pdo->rollBack(); return null; }

            // mark them used
            $in = implode(',', array_fill(0, count($ids), '?'));
            $stmt = $pdo->prepare("UPDATE stamps SET used_for_voucher = 1 WHERE id IN ($in)");
            $stmt->execute($ids);

            // generate voucher code and save
            $code = generate_unique_code($pdo, 8);
            $voucher_meta = json_encode(['value'=>'Rp20.000','user_id'=>$user_id]);
            $stmt = $pdo->prepare("INSERT INTO order_codes (code, valid_date, source, category, meta) VALUES (?, ?, 'auto_loyalty', 'loyalty_voucher', ?)");
            $stmt->execute([$code, date('Y-m-d'), $voucher_meta]);

            $pdo->commit();
            return $code;
        } catch (Exception $e) {
            $pdo->rollBack();
            // on fail return null
            return null;
        }
    }
}

  

function current_user($pdo){
    if(session_status() !== PHP_SESSION_ACTIVE) session_start();
    if(empty($_SESSION['user_id'])) return null;
    $stmt = $pdo->prepare("SELECT id,email,name,referral_code,signup_referral_code FROM users WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    return $stmt->fetch(PDO::FETCH_ASSOC);
}
?>