<?php
// index.php - Hiyori Artisan Matcha landing (replace / upload to public_html/hiyorimatcha/index.php)
?><!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Hiyori Artisan Matcha — Artisan Ceremonial Matcha</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet" />
  <style>
    html { scroll-behavior: smooth; }
    body { -webkit-font-smoothing:antialiased; -moz-osx-font-smoothing:grayscale; }
    .menu-track { display:flex; transition: transform 1200ms cubic-bezier(.22,.9,.23,1); will-change: transform; }
    .menu-slide { flex: 0 0 100%; display:flex; gap:2.5rem; align-items:center; padding: 1rem 0; }
    .vertical-accent { position: absolute; left: -56px; top: 50%; transform: translateY(-50%); z-index:0; pointer-events:none; }
   @media (max-width:768px){
  .menu-slide{ flex-direction:column; }
  .vertical-accent{ display:none }
  .menu-slide img { width:100%; height:auto; max-height:250px; object-fit:cover; border-radius:0.75rem; }
}

    .hero-bg { background-image: url('https://images.unsplash.com/photo-1509042239860-f550ce710b93?ixlib=rb-4.0.3&q=80&w=1600&auto=format&fit=crop'); background-size:cover; background-position:center; }
  </style>
</head>
<body class="bg-white text-gray-800">

  <!-- header (consistent) -->
  <header class="fixed top-0 left-0 w-full z-40 bg-white/90 backdrop-blur border-b border-[#E6F0E8]">
    <div class="max-w-6xl mx-auto px-6">
      <nav class="flex items-center justify-between h-20">
        <a href="/hiyorimatcha/index.php" class="text-2xl tracking-widest font-serif text-[#355f44]">HIYORI</a>
        <ul class="hidden md:flex gap-8 items-center text-gray-700">
          <li><a href="#home" class="hover:text-black transition">Home</a></li>
          <li><a href="#story" class="hover:text-black transition">Story</a></li>
          <li><a href="#craft" class="hover:text-black transition">Craft</a></li>
          <li><a href="#menu" class="hover:text-black transition">Menu</a></li>
          <li><a href="#contact" class="hover:text-black transition">Contact</a></li>
        </ul>
        <div class="flex items-center gap-3">
          <a href="/hiyorimatcha/auth/register.php" class="text-sm px-3 py-2 border rounded-md hidden md:inline">Sign up</a>
          <a href="/hiyorimatcha/auth/login.php" class="text-sm px-3 py-2 bg-[#4A7C59] text-white rounded-md">Login</a>
        </div>
      </nav>
    </div>
  </header>

  <!-- HERO -->
  <section id="home" class="relative min-h-screen flex items-center justify-center overflow-hidden text-white hero-bg">
    <div class="absolute inset-0 bg-black/30"></div>
    <div class="relative z-10 text-center max-w-3xl px-6" data-aos="fade-up">
      <h1 class="text-6xl md:text-7xl font-serif tracking-[0.15em]">HIYORI</h1>
      <p class="mt-6 text-2xl font-light opacity-90">Artisan Ceremonial Matcha — Hand-whisked, wholesome, and mindful.</p>
      <div class="mt-8 flex justify-center gap-4">
        <a href="#menu" class="px-6 py-3 bg-white text-[#3b6f45] rounded-lg shadow font-medium">Order Now</a>
        <a href="#story" class="px-6 py-3 border border-white rounded-lg">Our Story</a>
      </div>
    </div>
    <div class="absolute bottom-10 text-4xl animate-bounce z-10">
      <a href="#story">↓</a>
    </div>
  </section>

  <!-- STORY -->
  <section id="story" class="py-24 max-w-6xl mx-auto px-6 grid md:grid-cols-2 gap-12 items-center">
    <div data-aos="fade-right">
      <h2 class="text-4xl font-serif text-[#4A7C59]">The Meaning of Hiyori</h2>
      <p class="mt-6 text-lg text-gray-700 leading-relaxed">“Hiyori” is a perfect clear day — peaceful, calm, and refreshing. We bring that moment to your cup with traditional whisking and ceremonial-grade matcha.</p>
    </div>
    <div data-aos="fade-left"><img src="https://images.unsplash.com/photo-1523906834658-6e24ef2386f9?ixlib=rb-4.0.3&q=80&w=1200&auto=format&fit=crop" class="rounded-3xl shadow-xl" alt="ceremonial matcha" /></div>
  </section>

  <!-- CRAFT -->
  <section id="craft" class="py-24 bg-[#F7F8F3]">
    <div class="max-w-6xl mx-auto px-6 grid md:grid-cols-2 gap-12 items-center">
      <div data-aos="fade-right"><img src="https://images.unsplash.com/photo-1542444459-db53bbdd8cfc?ixlib=rb-4.0.3&q=80&w=1200&auto=format&fit=crop" class="rounded-3xl shadow-xl" alt="whisking matcha" /></div>
      <div data-aos="fade-left">
        <h3 class="text-3xl font-serif text-[#4A7C59]">Crafted With Intention</h3>
        <p class="mt-6 text-lg text-gray-700 leading-relaxed">Hand-whisked using chasen, oat milk, and brown sugar — no creamer, no artificial sweeteners. A moment of calm in every sip.</p>
      </div>
    </div>
  </section>

  <!-- MENU CAROUSEL (infinite, smooth) -->
  <section id="menu" class="py-24 max-w-6xl mx-auto px-6">
    <h2 class="text-4xl font-serif text-center text-[#4A7C59] mb-10" data-aos="fade-up">Our Signature</h2>

    <div class="relative overflow-hidden">
      <button id="prev" class="absolute left-4 top-1/2 -translate-y-1/2 z-20 bg-white rounded-full p-2 shadow">‹</button>
      <button id="next" class="absolute right-4 top-1/2 -translate-y-1/2 z-20 bg-white rounded-full p-2 shadow">›</button>

      <div id="track" class="menu-track">
        <!-- slide 1 -->
        <div class="menu-slide">
          <div class="w-1/2 md:w-1/2"><img src="https://images.unsplash.com/photo-1587301668919-70229f8ccf62?ixlib=rb-4.0.3&q=80&w=1200&auto=format&fit=crop" class="rounded-3xl shadow-xl w-full h-96 object-cover" alt="matcha latte" /></div>
          <div class="w-1/2 md:w-1/2">
            <h3 class="text-3xl font-serif text-[#4A7C59]">Hiyori Matcha Latte</h3>
            <p class="mt-4 text-gray-700 leading-relaxed">4g pure high-grade matcha — hand-whisked, oat milk, brown sugar. 360ml. Includes a complimentary ginger candy.</p>
            <div class="mt-6"><a href="https://linktr.ee/hiyorimatcha" class="px-6 py-3 bg-[#4A7C59] text-white rounded-lg">Order Now</a></div>
          </div>
        </div>

        <!-- slide 2 -->
        <div class="menu-slide">
          <div class="w-1/2"><img src="https://images.unsplash.com/photo-1542444459-db53bbdd8cfc?ixlib=rb-4.0.3&q=80&w=1200&auto=format&fit=crop" class="rounded-3xl shadow-xl w-full h-96 object-cover" alt="signature blend" /></div>
          <div class="w-1/2">
            <h3 class="text-3xl font-serif text-[#4A7C59]">Signature Blend</h3>
            <p class="mt-4 text-gray-700 leading-relaxed">Ceremonial notes balanced for everyday comfort.</p>
            <div class="mt-6"><a href="https://linktr.ee/hiyorimatcha"  class="px-6 py-3 bg-[#4A7C59] text-white rounded-lg">Order Now</a></div>
          </div>
        </div>

        <!-- slide 3 -->
        <div class="menu-slide">
          <div class="w-1/2"><img src="https://images.unsplash.com/photo-1504674900247-0877df9cc836?ixlib=rb-4.0.3&q=80&w=1200&auto=format&fit=crop" class="rounded-3xl shadow-xl w-full h-96 object-cover" alt="ceremonial upgrade" /></div>
          <div class="w-1/2">
            <h3 class="text-3xl font-serif text-[#4A7C59]">Ceremonial Upgrade</h3>
            <p class="mt-4 text-gray-700 leading-relaxed">Deeper, more aromatic ceremonial-grade experience.</p>
            <div class="mt-6"><a href="https://linktr.ee/hiyorimatcha" class="px-6 py-3 bg-[#4A7C59] text-white rounded-lg">Order Now</a></div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- contact -->
  <section id="contact" class="py-20 bg-[#F7F8F3]">
    <div class="max-w-4xl mx-auto px-6 text-center" data-aos="fade-up">
      <h3 class="text-3xl font-serif text-[#4A7C59] mb-4">Contact & Partnerships</h3>
      <p class="text-gray-700 mb-4">We'd love to hear from you — orders, collaborations, and partnerships.</p>
      <div class="flex justify-center gap-8 items-center">
        <a href="https://wa.me/6287873640479" class="flex items-center gap-2 text-[#355f44]"> <!-- WA link -->
          <svg width="18" height="18" viewBox="0 0 24 24" fill="none"><path d="M20.52 3.48A11.86 11.86 0 0 0 12 0C5.373 0 0 5.373 0 12c0 2.116.553 4.164 1.6 5.98L0 24l6.234-1.61A11.946 11.946 0 0 0 12 24c6.627 0 12-5.373 12-12 0-1.947-.444-3.786-1.48-5.22zM12 21.5c-1.2 0-2.37-.28-3.42-.8l-.25-.12L5 20l1.86-2.36-.16-.28A8.5 8.5 0 1 1 20.5 12 8.46 8.46 0 0 1 12 21.5z" stroke="currentColor" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/></svg>
          +62 878-7364-0479
        </a>
        <a href="https://instagram.com/hiyorimatcha" target="_blank" class="flex items-center gap-2 text-[#355f44]">
          <svg width="18" height="18" viewBox="0 0 24 24" fill="none"><rect x="2" y="2" width="20" height="20" rx="5" stroke="currentColor" stroke-width="1.2"/><path d="M16 11.37A4 4 0 1 1 12.63 8 4 4 0 0 1 16 11.37z" stroke="currentColor" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/></svg>
          @hiyorimatcha
        </a>
      </div>
    </div>
  </section>

  <!-- footer -->
  <footer class="bg-white border-t mt-12">
    <div class="max-w-6xl mx-auto px-6 py-8 flex flex-col md:flex-row items-center justify-between">
      <div class="text-sm text-gray-700">© 2025 Hiyori Artisan Matcha — All rights reserved.</div>
      <div class="text-sm text-gray-700">Contact: <a class="text-[#355f44]" href="https://wa.me/6287873640479">+62 878-7364-0479</a> • <a class="text-[#355f44]" href="https://instagram.com/hiyorimatcha">@hiyorimatcha</a></div>
    </div>
  </footer>

<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
<script>
AOS.init({ duration: 1000, once: true });

// Smooth infinite carousel: clone first and last slide trick
const track = document.getElementById('track');
const slides = Array.from(track.children);
let index = 0;
let isMoving = false;
const total = slides.length;

// clone first and last for seamless loop
const firstClone = slides[0].cloneNode(true);
const lastClone = slides[slides.length-1].cloneNode(true);
track.appendChild(firstClone);
track.insertBefore(lastClone, slides[0]);

// set track width handled by CSS (flex); we'll move by percentage
function goTo(i, instant = false) {
  if (isMoving) return;
  isMoving = true;
  track.style.transition = instant ? 'none' : 'transform 1200ms cubic-bezier(.22,.9,.23,1)';
  const transformX = -(i+1) * 100; // because of prepended clone
  track.style.transform = `translateX(${transformX}%)`;
  setTimeout(()=> { isMoving = false; }, 1300);
  index = i;
}

// initial position to the first real slide
track.style.transform = `translateX(-100%)`;

// next/prev
document.getElementById('next').addEventListener('click', ()=> { goTo((index+1) % total); resetAuto(); });
document.getElementById('prev').addEventListener('click', ()=> { goTo((index-1+total) % total); resetAuto(); });

// auto
let timer = setInterval(()=> { goTo((index+1) % total); }, 3000);
function resetAuto(){ clearInterval(timer); timer = setInterval(()=> { goTo((index+1) % total); }, 3000); }

// touch support
let startX = 0, moved=false;
track.addEventListener('touchstart', e => { startX = e.touches[0].clientX; clearInterval(timer); moved=false; });
track.addEventListener('touchmove', e => { moved=true; });
track.addEventListener('touchend', e => { const dx = e.changedTouches[0].clientX - startX; if (Math.abs(dx) > 40) { if (dx < 0) { goTo((index+1)%total); } else { goTo((index-1+total)%total); } } resetAuto(); });

</script>
</body>
</html>
