<?php
// auth/register.php
// DEBUG: show errors while testing. Remove or comment these lines in production.
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../scripts/db.php';
if (session_status() !== PHP_SESSION_ACTIVE) session_start();

function normalize_phone($raw){
    $p = preg_replace('/[^0-9+]/','',$raw);
    if (substr($p,0,2) === '08') {
        $p = '62' . substr($p,1);
    }
    return $p;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = strtolower(trim($_POST['email'] ?? ''));
    $pass = $_POST['password'] ?? '';
    $name = trim($_POST['name'] ?? '');
    $signupReferral = strtoupper(trim($_POST['signup_referral_code'] ?? '')) ?: null;
    $phone_raw = trim($_POST['phone'] ?? '');
    $phone = $phone_raw ? normalize_phone($phone_raw) : null;

    if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL) || strlen($pass) < 6) {
        $err = "Please enter a valid email and a password with at least 6 characters.";
    } else {
        // check email uniqueness
        $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->execute([$email]);
        if ($stmt->fetch()) {
            $err = "Email already being used. Please use a different email or contact support to recover your account.";
        } else {
            // if signupReferral provided, validate it exists
            if ($signupReferral) {
                $stmt = $pdo->prepare("SELECT id FROM users WHERE referral_code = ?");
                $stmt->execute([$signupReferral]);
                if (!$stmt->fetch()) {
                    $err = "Referral code not found. Please double-check the code or leave it blank.";
                }
            }
            if (empty($err)) {
                // generate referral: first 3 letters of name (letters only) + 3 random alnum
                $base = strtoupper(substr(preg_replace('/[^A-Za-z]/', '', $name), 0, 3));
                if (!$base) $base = 'HIY';
                do {
                    $suffix = rand_str(3);
                    $ref = $base . $suffix;
                    $stmt = $pdo->prepare("SELECT id FROM users WHERE referral_code = ?");
                    $stmt->execute([$ref]);
                } while ($stmt->fetch());

                $hash = password_hash($pass, PASSWORD_DEFAULT);

                $stmt = $pdo->prepare("INSERT INTO users (email,password_hash,name,referral_code,signup_referral_code,phone) VALUES (?, ?, ?, ?, ?, ?)");
                $stmt->execute([$email, $hash, $name, $ref, $signupReferral, $phone]);
                $newId = (int)$pdo->lastInsertId();

                // record referral usage for admin tracking (if provided)
                if ($signupReferral) {
                    $stmt = $pdo->prepare("SELECT id FROM users WHERE referral_code = ?");
                    $stmt->execute([$signupReferral]);
                    $r = $stmt->fetch(PDO::FETCH_ASSOC);
                    if ($r) {
                        $stmt = $pdo->prepare("INSERT INTO referrals (referrer_id, referral_code_used, new_user_id) VALUES (?, ?, ?)");
                        $stmt->execute([$r['id'], $signupReferral, $newId]);
                    }
                }

                // Auto-login the new user (set session) and redirect to account
                $_SESSION['user_id'] = $newId;
                header('Location: /hiyorimatcha/account.php');
                exit;
            }
        }
    }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Sign up — Hiyori</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet" />
  <style>html{scroll-behavior:smooth}</style>
</head>
<body class="bg-white text-gray-800">
  <header class="fixed top-0 left-0 w-full z-50 bg-white/80 backdrop-blur-lg border-b border-[#4A7C59]/20">
    <nav class="max-w-6xl mx-auto flex items-center justify-between p-4 text-[#4A7C59] font-serif">
      <a href="/hiyorimatcha/index.php" class="text-2xl">HIYORI</a>
      <a href="/hiyorimatcha/auth/login.php" class="text-sm px-3 py-2">Login</a>
    </nav>
  </header>

  <main class="pt-28 max-w-md mx-auto px-6">
    <section class="bg-[#F7F8F3] rounded-2xl p-8 shadow-md" data-aos="fade-up">
      <h1 class="text-2xl font-serif text-[#4A7C59]">Create account</h1>

      <?php if(!empty($err)): ?><div class="mt-4 text-red-600"><?=htmlspecialchars($err)?></div><?php endif; ?>

      <form method="post" class="mt-6 space-y-4" autocomplete="off">
        <div>
          <label class="text-sm text-gray-600">Full name</label>
          <input name="name" required class="w-full px-4 py-3 border rounded-md" />
        </div>

        <div>
          <label class="text-sm text-gray-600">Email</label>
          <input name="email" type="email" required class="w-full px-4 py-3 border rounded-md" />
        </div>

        <div>
          <label class="text-sm text-gray-600">Password</label>
          <input name="password" type="password" required class="w-full px-4 py-3 border rounded-md" />
        </div>

        <div>
          <label class="text-sm text-gray-600">Phone (for order/contact)</label>
          <input name="phone" type="text" placeholder="08xxxxxxxxxx or +628xxxxxxxx" class="w-full px-4 py-3 border rounded-md" />
          <p class="text-xs text-gray-500 mt-1">If you enter a number starting with 08, it will be saved as 62... for WhatsApp links.</p>
        </div>

        <div>
          <label class="text-sm text-gray-600">Referral code (optional)</label>
          <input name="signup_referral_code" class="w-full px-4 py-3 border rounded-md" />
        </div>

        <div>
          <button type="submit" class="w-full py-3 bg-[#4A7C59] text-white rounded-md">Create account</button>
        </div>
      </form>

      <p class="mt-4 text-sm text-gray-600">Already have an account? <a href="login.php" class="text-[#4A7C59]">Login</a></p>
      <p class="mt-2 text-sm text-gray-600">Forgot password? <a href="/hiyorimatcha/auth/forgot_instructions.php" class="text-[#4A7C59]">Contact owner for reset</a></p>
    </section>
  </main>

<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script><script>AOS.init({ duration:800, once:true });</script>
</body>
</html>
