<?php
session_start();
require_once __DIR__ . '/../scripts/db.php';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = strtolower(trim($_POST['email'] ?? ''));
    $pass = $_POST['password'] ?? '';
    $stmt = $pdo->prepare("SELECT id,password_hash FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $u = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($u && password_verify($pass, $u['password_hash'])) {
        $_SESSION['user_id'] = $u['id'];
        header('Location: /hiyorimatcha/account.php');
        exit;
    } else {
        // generic message for security + clearer wording
        $err = "Email or password is incorrect. If you forgot your password, contact the owner to generate a one-time reset token.";
    }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Login — Hiyori</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet" />
  <style>html{scroll-behavior:smooth}</style>
</head>
<body class="bg-white text-gray-800">
  <header class="fixed top-0 left-0 w-full z-50 bg-white/80 backdrop-blur-lg border-b border-[#4A7C59]/20">
    <nav class="max-w-6xl mx-auto flex items-center justify-between p-4 text-[#4A7C59] font-serif">
      <a href="/hiyorimatcha/index.php" class="text-2xl">HIYORI</a>
      <a href="/hiyorimatcha/auth/register.php" class="text-sm px-3 py-2">Sign up</a>
    </nav>
  </header>

  <main class="pt-28 max-w-md mx-auto px-6">
    <section class="bg-[#F7F8F3] rounded-2xl p-8 shadow-md" data-aos="fade-up">
      <h1 class="text-2xl font-serif text-[#4A7C59]">Welcome back</h1>
      <?php if(!empty($err)): ?><div class="mt-4 text-red-600"><?=htmlspecialchars($err)?></div><?php endif; ?>

      <form method="post" class="mt-6 space-y-4">
        <div><label class="text-sm text-gray-600">Email</label><input name="email" type="email" required class="w-full px-4 py-3 border rounded-md" /></div>
        <div><label class="text-sm text-gray-600">Password</label><input name="password" type="password" required class="w-full px-4 py-3 border rounded-md" /></div>
        <div><button type="submit" class="w-full py-3 bg-[#4A7C59] text-white rounded-md">Login</button></div>
      </form>

      <p class="mt-4 text-sm text-gray-600">No account? <a href="register.php" class="text-[#4A7C59]">Create one</a></p>
      <p class="mt-2 text-sm text-gray-600">Forgot password? <a href="/hiyorimatcha/auth/forgot_instructions.php" class="text-[#4A7C59]">Contact owner for reset</a></p>
    </section>
  </main>

<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script><script>AOS.init({ duration:800, once:true });</script>
</body>
</html>
