<?php
require_once __DIR__ . '/scripts/db.php';
session_start();
header('Content-Type: application/json');
if (empty($_SESSION['user_id'])) { http_response_code(403); echo json_encode(['error'=>'Not logged in']); exit; }
$uid = (int)$_SESSION['user_id'];

// loyalty and referral stamps
$stmt = $pdo->prepare("SELECT type, COUNT(*) as c FROM stamps WHERE user_id = ? GROUP BY type");
$stmt->execute([$uid]); $stamps = []; while($r=$stmt->fetch(PDO::FETCH_ASSOC)) $stamps[$r['type']] = (int)$r['c'];
$loyalty = $stamps['loyalty'] ?? 0;
$referral = $stamps['referral'] ?? 0;

// coins: 1 coin = (every 2 loyalty stamps) => coins = floor(loyalty/2) - coins_already_spent
// We'll compute coins as floor(loyalty/2) minus number of draws used to spend coins (draws table where user used coin)
$coins_generated = intdiv($loyalty, 2);
$stmt = $pdo->prepare("SELECT COUNT(*) FROM draws WHERE user_id = ? AND used_coin = 1");
$stmt->execute([$uid]);
$coins_spent = (int)$stmt->fetchColumn();
$coins = max(0, $coins_generated - $coins_spent);

// attempts info (to enforce guarantee & no-consecutive-win 3)
$stmt = $pdo->prepare("SELECT attempt_no, won, created_at FROM draws WHERE user_id = ? ORDER BY id DESC LIMIT 5");
$stmt->execute([$uid]);
$recent = $stmt->fetchAll(PDO::FETCH_ASSOC);
$attempts = [];
foreach ($recent as $r) $attempts[] = ['attempt_no'=>(int)$r['attempt_no'],'won'=>(int)$r['won'],'created_at'=>$r['created_at']];

// compute streak since last win
$sinceLastWin = 0;
$lastWins = array_filter($recent, function($r){ return $r['won']; });
if (!empty($lastWins)) {
    // find latest win index:
    $found = false; $count=0;
    foreach ($recent as $r) {
        $count++;
        if ($r['won']) { $sinceLastWin = $count - 1; $found=true; break; }
    }
    if (!$found) $sinceLastWin = count($recent);
} else {
    $sinceLastWin = count($recent);
}

// attempts until guarantee (guarantee at 5 tries)
$attempts_total = 0;
$stmt = $pdo->prepare("SELECT COUNT(*) FROM draws WHERE user_id = ?");
$stmt->execute([$uid]);
$attempts_total = (int)$stmt->fetchColumn();
$attempts_since_last_win = 0;
$stmt = $pdo->prepare("SELECT id,won FROM draws WHERE user_id = ? ORDER BY id DESC");
$stmt->execute([$uid]);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
$since = 0;
foreach ($rows as $r) {
  if ($r['won']) break;
  $since++;
}
$next_guarantee_left = max(0, 5 - $since);

// return data
echo json_encode([
  'loyalty'=>$loyalty,
  'referral'=>$referral,
  'coins'=>$coins,
  'attempts_since_last_win'=>$since,
  'next_guarantee_left'=>$next_guarantee_left,
  'recent'=>$attempts
]);
