<?php
require_once __DIR__ . '/../scripts/db.php';
$secret = $_GET['admin_secret'] ?? '';
if ($secret !== $ADMIN_SECRET) { http_response_code(403); echo 'Forbidden'; exit; }
$email = trim($_GET['email'] ?? '');
$amount = floatval($_GET['amount'] ?? 0);
$order_ref = trim($_GET['order_ref'] ?? null);
if (!$email) { http_response_code(400); echo 'Email required'; exit; }

// find user
$stmt = $pdo->prepare("SELECT * FROM users WHERE email = ? LIMIT 1");
$stmt->execute([$email]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$user) { http_response_code(404); echo 'User not found'; exit; }
$uid = (int)$user['id'];

// Insert purchase
$stmt = $pdo->prepare("INSERT INTO purchases (user_id, order_ref, amount) VALUES (?, ?, ?)");
$stmt->execute([$uid, $order_ref, $amount]);

// Check if first purchase for this user
$stmt = $pdo->prepare("SELECT COUNT(*) FROM purchases WHERE user_id = ?");
$stmt->execute([$uid]);
$countPurchases = (int)$stmt->fetchColumn();

// If it is user's first purchase AND they used a signup_referral_code -> grant new-user loyalty + give referrer a referral stamp
if ($countPurchases === 1 && !empty($user['signup_referral_code'])) {
    // give new user a loyalty stamp
    $stmt = $pdo->prepare("INSERT INTO stamps (user_id,type) VALUES (?, 'loyalty')");
    $stmt->execute([$uid]);

    // find referrer
    $stmt = $pdo->prepare("SELECT id FROM users WHERE referral_code = ? LIMIT 1");
    $stmt->execute([ $user['signup_referral_code'] ]);
    $ref = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($ref) {
        // give referrer 1 referral stamp (converted=0)
        $stmt = $pdo->prepare("INSERT INTO stamps (user_id,type,converted) VALUES (?, 'referral', 0)");
        $stmt->execute([ $ref['id'] ]);
    }
}

// Also: when ANY user makes a purchase, convert ONE referral stamp to loyalty for that purchasing user (if they have referral stamps)
$stmt = $pdo->prepare("SELECT id FROM stamps WHERE user_id = ? AND type = 'referral' AND converted = 0 ORDER BY id ASC LIMIT 1");
$stmt->execute([$uid]);
$refStamp = $stmt->fetch(PDO::FETCH_ASSOC);
if ($refStamp) {
    // mark referral stamp as converted and insert a loyalty stamp
    $pdo->beginTransaction();
    try {
        $stmt = $pdo->prepare("UPDATE stamps SET converted = 1 WHERE id = ?");
        $stmt->execute([$refStamp['id']]);
        $stmt = $pdo->prepare("INSERT INTO stamps (user_id,type,converted) VALUES (?, 'loyalty', 1)");
        $stmt->execute([$uid]);
        $pdo->commit();
    } catch (Exception $e) {
        $pdo->rollBack();
    }
}

echo "Purchase recorded. User purchases: {$countPurchases}.";
