<?php
require_once __DIR__ . '/../scripts/db.php';
$secret = trim($_GET['admin_secret'] ?? '');
$email = trim($_GET['email'] ?? '');
if ($secret !== $ADMIN_SECRET) { http_response_code(403); echo 'Forbidden'; exit; }
if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)) { http_response_code(400); echo 'Invalid email'; exit; }

// ensure password_resets table exists (safe to run multiple times)
$pdo->exec("
CREATE TABLE IF NOT EXISTS password_resets (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  email VARCHAR(255) NOT NULL,
  token VARCHAR(128) NOT NULL UNIQUE,
  expires_at DATETIME NOT NULL,
  used TINYINT(1) NOT NULL DEFAULT 0,
  used_at DATETIME NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

// make sure user exists
$stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
$stmt->execute([$email]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$user) { http_response_code(404); echo 'User not found'; exit; }

// generate secure random token (48 hex)
$token = bin2hex(random_bytes(24));
$expires = date('Y-m-d H:i:s', time() + 24*3600); // 24 hours

$stmt = $pdo->prepare("INSERT INTO password_resets (user_id,email,token,expires_at,used) VALUES (?, ?, ?, ?, 0)");
$stmt->execute([$user['id'], $email, $token, $expires]);

echo "RESET TOKEN: {$token}\nExpires: {$expires}\nGive this token to the user and instruct them to visit: /hiyorimatcha/auth/reset.php?token={$token}";
