CREATE TABLE users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  email VARCHAR(255) UNIQUE NOT NULL,
  password_hash VARCHAR(255) NOT NULL,
  name VARCHAR(120),
  referral_code VARCHAR(12) UNIQUE NOT NULL,
  signup_referral_code VARCHAR(12),
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
CREATE TABLE order_codes (
  id INT AUTO_INCREMENT PRIMARY KEY,
  code CHAR(6) UNIQUE NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  valid_date DATE NOT NULL,
  used_by INT NULL,
  used_at TIMESTAMP NULL,
  source VARCHAR(64) NULL
);
CREATE TABLE stamps (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  type ENUM('loyalty','referral') NOT NULL,
  source_code_id INT,
  converted TINYINT(1) DEFAULT 0,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
CREATE TABLE referrals (
  id INT AUTO_INCREMENT PRIMARY KEY,
  referrer_id INT NOT NULL,
  referral_code_used VARCHAR(12) NOT NULL,
  new_user_id INT DEFAULT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
CREATE TABLE draws (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  attempt_no INT NOT NULL,
  won TINYINT(1) DEFAULT 0,
  prize VARCHAR(255) NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
CREATE TABLE redeem_logs (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT,
  code_id INT,
  ip VARCHAR(45),
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
