<?php
// prize/verify.php - admin endpoint to mark prize code as claimed
declare(strict_types=1);
require_once __DIR__ . '/../scripts/db.php';
$secret = $_GET['admin_secret'] ?? '';
if ($secret !== 'hoki') {
    http_response_code(403);
    echo json_encode(['success'=>false,'message'=>'unauthorized']);
    exit;
}
$code = $_POST['code'] ?? '';
if (!$code) { echo json_encode(['success'=>false,'message'=>'no code']); exit; }
$stmt = $pdo->prepare('SELECT id, claimed FROM prize_codes WHERE code = :c LIMIT 1');
$stmt->execute([':c'=>$code]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$row) { echo json_encode(['success'=>false,'message'=>'not found']); exit; }
if ($row['claimed']) { echo json_encode(['success'=>false,'message'=>'already claimed']); exit; }
$pdo->prepare('UPDATE prize_codes SET claimed = 1, claimed_at = NOW() WHERE id = :id')->execute([':id'=>$row['id']]);
echo json_encode(['success'=>true,'message'=>'claimed']);
?>