<?php
require_once __DIR__ . '/../scripts/db.php';
$secret = $_GET['admin_secret'] ?? '';
if ($secret !== $ADMIN_SECRET) { http_response_code(403); echo 'Forbidden'; exit; }
$q = trim($_GET['q'] ?? '');
$param = '%' . $q . '%';
$stmt = $pdo->prepare("SELECT id, name, email, phone, referral_code, created_at FROM users WHERE name LIKE ? OR email LIKE ? OR phone LIKE ? ORDER BY id DESC LIMIT 200");
$stmt->execute([$param,$param,$param]);
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1"><title>Admin - Users</title><link rel="stylesheet" href="assets/style.css"></head><body>
<div class="wrap">
<h1>Users</h1>
<form>
  <input name="q" value="<?php echo htmlspecialchars($q)?>" placeholder="Search name/email/phone" />
  <input type="hidden" name="admin_secret" value="<?php echo htmlspecialchars($secret)?>" />
  <button>Search</button>
</form>
<table>
  <thead><tr><th>ID</th><th>Name</th><th>Email</th><th>Phone</th><th>Referral</th><th>Joined</th><th>Actions</th></tr></thead>
  <tbody>
  <?php foreach($users as $u): ?>
    <tr>
      <td><?php echo htmlspecialchars($u['id'])?></td>
      <td><?php echo htmlspecialchars($u['name'])?></td>
      <td><?php echo htmlspecialchars($u['email'])?></td>
      <td><?php echo htmlspecialchars($u['phone'])?></td>
      <td><?php echo htmlspecialchars($u['referral_code'])?></td>
      <td><?php echo htmlspecialchars($u['created_at'])?></td>
      <td>
        <?php if(!empty($u['phone'])):
          $waPhone = preg_replace('/[^0-9]/','',$u['phone']);
          if (strpos($waPhone,'08') === 0) { $waPhone = '62'.substr($waPhone,1); }
        ?>
        <a target="_blank" href="https://wa.me/<?php echo htmlspecialchars($waPhone)?>">WhatsApp</a>
        <?php endif; ?>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
</div></body></html>
