<?php
// File: /home/hiyorima/public_html/hiyorimatcha/priv/admin/customers.php
// Admin customer manager for Hiyori — safe & read-only by default unless admin performs actions.

// DEBUG: remove or comment out in production
ini_set('display_errors', 1);
error_reporting(E_ALL);

// load DB (adjust relative path to your scripts/db.php if needed)
$dbPath = __DIR__ . '/../../scripts/db.php';
if (!file_exists($dbPath)) { header('Content-Type:text/plain',true,500); echo "Missing db.php at: $dbPath"; exit; }
require_once $dbPath;

// admin secret guard (if you set ADMIN_SECRET in scripts/db.php)
$secret = $_GET['admin_secret'] ?? '';
if (defined('ADMIN_SECRET') && ADMIN_SECRET !== $secret) {
    http_response_code(403);
    echo 'Forbidden';
    exit;
}

// helper: safe output
function h($s){ return htmlspecialchars($s ?? '', ENT_QUOTES, 'UTF-8'); }

// --- ACTIONS: admin operations (grant stamp, generate code, mark code used)
$action = $_POST['action'] ?? $_GET['action'] ?? '';
$feedback = '';

if ($action === 'grant_stamp' && !empty($_POST['user_id']) && !empty($_POST['stamp_type'])) {
    $uid = intval($_POST['user_id']);
    $t = in_array($_POST['stamp_type'], ['loyalty','referral']) ? $_POST['stamp_type'] : 'loyalty';
    $src = $_POST['source'] ?? 'admin_grant';
    $stmt = $pdo->prepare("INSERT INTO loyalty_stamps (user_id,type,source) VALUES (?, ?, ?)");
    $stmt->execute([$uid, $t, $src]);
    $feedback = "Granted $t stamp to user #$uid";
}

if ($action === 'generate_code' && !empty($_POST['user_id']) && !empty($_POST['category'])) {
    // code generation logic: 3 random alnum + 2-digit date + first letter of month (as you described earlier)
    $uid = intval($_POST['user_id']);
    $cat = substr(preg_replace('/[^a-z0-9_]/i','',$_POST['category']),0,32);
    $d = new DateTime('now', new DateTimeZone('Asia/Jakarta'));
    $datepart = $d->format('d') . strtoupper(substr($d->format('F'),0,1)); // e.g., 04N
    // create 3 random alnum chars
    $randPart = substr(str_shuffle('ABCDEFGHJKMNPQRSTUVWXYZ23456789'),0,3);
    $code = $randPart . $datepart;
    // ensure uniqueness (very small table so loop is fine)
    $i=0;
    while ($i<10) {
        $stmt = $pdo->prepare("SELECT id FROM order_codes WHERE code = ? LIMIT 1");
        $stmt->execute([$code]);
        if ($stmt->fetch()) { $randPart = substr(str_shuffle('ABCDEFGHJKMNPQRSTUVWXYZ23456789'),0,3); $code = $randPart . $datepart; $i++; } else break;
    }
    // save
    $stmt = $pdo->prepare("INSERT INTO order_codes (code, category, generated_for_user, meta) VALUES (?, ?, ?, ?)");
    $stmt->execute([$code, $cat, $uid, json_encode(['generated_by'=>'admin'])]);
    $feedback = "Generated code $code for user #$uid";
}

if ($action === 'mark_code_used' && !empty($_POST['code_id']) && !empty($_POST['used_by'])) {
    $code_id = intval($_POST['code_id']);
    $used_by = intval($_POST['used_by']);
    $stmt = $pdo->prepare("UPDATE order_codes SET used_by = ?, used_at = NOW() WHERE id = ? AND used_by IS NULL");
    $stmt->execute([$used_by, $code_id]);
    if ($stmt->rowCount()) $feedback = "Code marked used for user #$used_by";
    else $feedback = "Code not found or already used";
}

// --- SEARCH: by name/email/phone/referral_code
$q = trim($_GET['q'] ?? '');
$cond = [];
$params = [];
if ($q !== '') {
    $cond[] = "(name LIKE ? OR email LIKE ? OR phone LIKE ? OR referral_code LIKE ? OR referred_by LIKE ?)";
    $like = "%$q%";
    $params = array_fill(0,5,$like);
}
$where = $cond ? 'WHERE ' . implode(' AND ', $cond) : '';
$limit = 200;
$stmt = $pdo->prepare("SELECT SQL_CALC_FOUND_ROWS * FROM users_customer $where ORDER BY id DESC LIMIT ? ");
$params[] = $limit;
$stmt->execute($params);
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);

// helper functions for counts
function count_stamps($pdo,$uid,$type=null){
    if ($type) {
        $s = $pdo->prepare("SELECT COUNT(*) FROM loyalty_stamps WHERE user_id = ? AND type = ?");
        $s->execute([$uid,$type]);
    } else {
        $s = $pdo->prepare("SELECT COUNT(*) FROM loyalty_stamps WHERE user_id = ?");
        $s->execute([$uid]);
    }
    return (int)$s->fetchColumn();
}
function get_codes_for_user($pdo,$uid){
    $s = $pdo->prepare("SELECT * FROM order_codes WHERE generated_for_user = ? ORDER BY id DESC LIMIT 200");
    $s->execute([$uid]);
    return $s->fetchAll(PDO::FETCH_ASSOC);
}
function get_lucky_history($pdo,$uid){
    $s = $pdo->prepare("SELECT * FROM lucky_draws WHERE user_id = ? ORDER BY id DESC LIMIT 50");
    $s->execute([$uid]);
    return $s->fetchAll(PDO::FETCH_ASSOC);
}

// CSV export for selected user
if (isset($_GET['export']) && $_GET['export']=='user' && !empty($_GET['uid'])) {
    $uid = intval($_GET['uid']);
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=user_'.$uid.'_export_'.date('Ymd_His').'.csv');
    $out = fopen('php://output','w');
    fputcsv($out, ['id','name','email','phone','username','referral_code','referred_by','created_at']);
    $s = $pdo->prepare("SELECT id,name,email,phone,username,referral_code,referred_by,created_at FROM users_customer WHERE id = ? LIMIT 1");
    $s->execute([$uid]);
    $row = $s->fetch(PDO::FETCH_ASSOC);
    fputcsv($out, array_values($row));
    fclose($out);
    exit;
}

?><!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Hiyori Admin — Customers</title>
<style>
body{font-family:Inter,system-ui,Arial,sans-serif;max-width:1100px;margin:18px auto;color:#222}
.header{display:flex;justify-content:space-between;align-items:center}
.search{margin:12px 0}
table{width:100%;border-collapse:collapse}
th,td{padding:8px;border:1px solid #eee;text-align:left}
.btn{display:inline-block;padding:6px 10px;background:#2f6a45;color:white;border-radius:6px;text-decoration:none}
.small{font-size:0.9rem;padding:6px 8px}
.feedback{background:#f0fff4;border-left:4px solid #2f6a45;padding:8px;margin:8px 0}
.form-inline{display:flex;gap:8px;align-items:center}
.form-inline select,input{padding:6px}
.code-box{background:#f7f7f7;padding:8px;border-radius:6px}
</style>
</head>
<body>
<div class="header">
  <h1>Customers</h1>
  <div><a class="btn" href="?admin_secret=<?php echo urlencode($secret)?>">Refresh</a></div>
</div>

<?php if($feedback): ?>
  <div class="feedback"><?php echo h($feedback) ?></div>
<?php endif; ?>

<form method="get" class="search" style="display:flex;gap:8px">
  <input name="q" placeholder="Search name / email / phone / referral" style="flex:1" value="<?php echo h($q) ?>">
  <input type="hidden" name="admin_secret" value="<?php echo h($secret) ?>">
  <button class="btn">Search</button>
</form>

<?php if(empty($users)): ?>
  <p>No customers found (try broader query).</p>
<?php else: ?>
  <table>
    <thead><tr><th>ID</th><th>Name</th><th>Email</th><th>Phone</th><th>Referral</th><th>Loyalty</th><th>ReferralStamps</th><th>LuckyHistory</th><th>Actions</th></tr></thead>
    <tbody>
    <?php foreach($users as $u): 
        $uid = (int)$u['id'];
        $loyal = count_stamps($pdo,$uid,'loyalty');
        $refst = count_stamps($pdo,$uid,'referral');
        $codes = get_codes_for_user($pdo,$uid);
        $lucky = get_lucky_history($pdo,$uid);
    ?>
      <tr>
        <td><?php echo $uid?></td>
        <td><?php echo h($u['name'])?><br><small><?php echo h($u['username'])?></small></td>
        <td><?php echo h($u['email'])?></td>
        <td><?php echo h($u['phone'])?></td>
        <td><div class="code-box"><?php echo h($u['referral_code'])?><?php if($u['referred_by']): ?><br><small>Used <?php echo h($u['referred_by'])?></small><?php endif;?></div></td>
        <td><?php echo $loyal?></td>
        <td><?php echo $refst?></td>
        <td>
          <?php foreach($lucky as $lh): ?>
            <div><?php echo h($lh['created_at'])?> - #<?php echo h($lh['attempt_number'])?> - <?php echo $lh['won_tiny']? 'WIN':'LOSE' ?> <?php if($lh['prize_code']) echo ' / '.$lh['prize_code']?></div>
          <?php endforeach; ?>
        </td>
        <td>
          <form method="post" style="margin-bottom:6px">
            <input type="hidden" name="action" value="grant_stamp">
            <input type="hidden" name="user_id" value="<?php echo $uid?>">
            <select name="stamp_type" class="small">
              <option value="loyalty">Grant Loyalty</option>
              <option value="referral">Grant Referral</option>
            </select>
            <button class="small">Grant</button>
          </form>

          <details style="margin-top:8px">
            <summary class="small">Codes (<?php echo count($codes)?>)</summary>
            <?php foreach($codes as $c): ?>
              <div style="margin:6px 0;padding:6px;background:#fafafa;border:1px solid #eee">
                <div><strong><?php echo h($c['code'])?></strong> — <?php echo h($c['category'])?></div>
                <div>Used by: <?php echo h($c['used_by'])?> at <?php echo h($c['used_at'])?></div>
                <form method="post" style="margin-top:6px">
                  <input type="hidden" name="action" value="mark_code_used">
                  <input type="hidden" name="code_id" value="<?php echo (int)$c['id']?>">
                  <input type="hidden" name="used_by" value="<?php echo $uid?>">
                  <button class="small">Mark as used</button>
                </form>
              </div>
            <?php endforeach; ?>

            <form method="post" style="margin-top:8px">
              <input type="hidden" name="action" value="generate_code">
              <input type="hidden" name="user_id" value="<?php echo $uid?>">
              <select name="category" class="small">
                <option value="lucky_freebie">Lucky Freebie</option>
                <option value="loyalty_voucher">Loyalty Voucher</option>
              </select>
              <button class="small">Generate Code</button>
            </form>
          </details>

          <div style="margin-top:6px">
            <a class="small" href="?admin_secret=<?php echo urlencode($secret)?>&export=user&uid=<?php echo $uid?>">Export CSV</a>
          </div>
        </td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
<?php endif; ?>

</body>
</html>
