<?php
require_once __DIR__ . '/../scripts/db.php';
$secret = $_GET['admin_secret'] ?? '';
if ($secret !== $ADMIN_SECRET) { http_response_code(403); echo 'Forbidden'; exit; }
$stmt = $pdo->prepare("SELECT id, code, category, used_by, used_at, meta FROM order_codes ORDER BY id DESC LIMIT 500");
$stmt->execute([]);
$codes = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1"><title>Admin - Codes</title><link rel="stylesheet" href="assets/style.css"></head><body>
<div class="wrap">
<h1>Codes</h1>
<table>
  <thead><tr><th>Code</th><th>Category</th><th>Used By</th><th>Used At</th><th>Meta</th></tr></thead>
  <tbody>
  <?php foreach($codes as $c): ?>
    <tr>
      <td><?php echo htmlspecialchars($c['code'])?></td>
      <td><?php echo htmlspecialchars($c['category'])?></td>
      <td><?php echo htmlspecialchars($c['used_by'])?></td>
      <td><?php echo htmlspecialchars($c['used_at'])?></td>
      <td><?php echo htmlspecialchars($c['meta'])?></td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
</div></body></html>
