-- Migration SQL for HiyoriMatcha: add required columns and create prize_codes, remove lucky draw tables
ALTER TABLE `users`
  ADD COLUMN IF NOT EXISTS `loyalty_stamps` INT NOT NULL DEFAULT 0,
  ADD COLUMN IF NOT EXISTS `referral_stamps` INT NOT NULL DEFAULT 0,
  ADD COLUMN IF NOT EXISTS `new_user_flag` TINYINT(1) NOT NULL DEFAULT 0,
  ADD COLUMN IF NOT EXISTS `cycle_bonus_classic_used` TINYINT(1) NOT NULL DEFAULT 0,
  ADD COLUMN IF NOT EXISTS `cycle_bonus_ceremonial_used` INT NOT NULL DEFAULT 0,
  ADD COLUMN IF NOT EXISTS `guarantee_counter` INT NOT NULL DEFAULT 0,
  ADD COLUMN IF NOT EXISTS `last_cycle_reset_at` DATETIME DEFAULT NULL;

CREATE TABLE IF NOT EXISTS `prize_codes` (
  `id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `user_id` INT DEFAULT NULL,
  `code` CHAR(6) NOT NULL UNIQUE,
  `type` ENUM('loyalty','freebies') NOT NULL DEFAULT 'loyalty',
  `claimed` TINYINT(1) NOT NULL DEFAULT 0,
  `claimed_at` DATETIME DEFAULT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  INDEX (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `lucky_draw_history`;
DROP TABLE IF EXISTS `lucky_draws`;
DROP TABLE IF EXISTS `draws`;

ALTER TABLE `order_codes` 
  MODIFY `meta` LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL;

-- add index (if supported)
ALTER TABLE `order_codes`
  ADD INDEX IF NOT EXISTS `idx_order_codes_code_valid` (`code`,`valid_date`);
