<?php
require_once __DIR__ . '/../scripts/db.php';
$token = $_GET['token'] ?? '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $token = $_POST['token'] ?? '';
    $password = $_POST['password'] ?? '';
    if (strlen($password) < 6) {
        $err = "Password must be at least 6 characters.";
    } else {
        // lookup token
        $stmt = $pdo->prepare("SELECT * FROM password_resets WHERE token = ? AND used = 0 LIMIT 1");
        $stmt->execute([$token]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) { $err = "Invalid or used token."; }
        else if (strtotime($row['expires_at']) < time()) { $err = "Token expired."; }
        else {
            // update user password
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $pdo->beginTransaction();
            try {
                $stmt = $pdo->prepare("UPDATE users SET password_hash = ? WHERE id = ?");
                $stmt->execute([$hash, $row['user_id']]);
                $stmt = $pdo->prepare("UPDATE password_resets SET used = 1, used_at = NOW() WHERE id = ?");
                $stmt->execute([$row['id']]);
                $pdo->commit();
                $success = "Password reset successful. You may now login.";
            } catch (Exception $e) {
                $pdo->rollBack();
                $err = "Error updating password.";
            }
        }
    }
}
?>
<!doctype html>
<html lang="en"><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1"><title>Reset Password — Hiyori</title>
<script src="https://cdn.tailwindcss.com"></script>
</head><body class="bg-white text-gray-800">
  <main class="pt-24 max-w-md mx-auto px-6">
    <section class="bg-[#F7F8F3] rounded-2xl p-8 shadow-md">
      <h1 class="text-2xl font-serif text-[#4A7C59]">Reset Password</h1>
      <?php if(!empty($err)): ?><div class="mt-4 text-red-600"><?=htmlspecialchars($err)?></div><?php endif; ?>
      <?php if(!empty($success)): ?><div class="mt-4 text-green-700"><?=htmlspecialchars($success)?></div><?php endif; ?>

      <?php if (empty($success)): ?>
      <form method="post" class="mt-6 space-y-4">
        <input type="hidden" name="token" value="<?=htmlspecialchars($token)?>" />
        <div><label class="text-sm text-gray-600">New password</label><input name="password" type="password" required class="w-full px-4 py-3 border rounded-md" /></div>
        <div><button type="submit" class="w-full py-3 bg-[#4A7C59] text-white rounded-md">Reset password</button></div>
      </form>
      <?php endif; ?>

      <p class="mt-4 text-sm"><a href="/hiyorimatcha/auth/login.php" class="text-[#4A7C59]">Back to login</a></p>
    </section>
  </main>
</body></html>
