<?php
// ajax_user_data.php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/scripts/db.php';
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success'=>false,'message'=>'not authenticated']);
    exit;
}
$uid = (int) $_SESSION['user_id'];
$stmt = $pdo->prepare('SELECT loyalty_stamps, referral_stamps, xp, tier FROM users WHERE id = :uid LIMIT 1');
$stmt->execute([':uid'=>$uid]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$row) {
    echo json_encode(['success'=>false,'message'=>'user not found']);
    exit;
}
$xp = (int)$row['xp'];
$tier = $row['tier'] ?? 'first';
$threshold = ($tier==='first')?100:(($tier==='classic')?500:0);
$percent = $threshold>0 ? min(100, (int)round(($xp/$threshold)*100)) : 100;
$prizeStmt = $pdo->prepare('SELECT id, code, type, claimed, created_at FROM prize_codes WHERE user_id = :uid ORDER BY created_at DESC');
$prizeStmt->execute([':uid'=>$uid]);
$prizes = $prizeStmt->fetchAll(PDO::FETCH_ASSOC);
$prizes_html = '';
if (count($prizes)===0) {
    $prizes_html = '<div class="no-prizes">No prizes yet</div>';
} else {
    $prizes_html = '<ul>';
    foreach($prizes as $p) {
        $prizes_html .= '<li><strong>'.htmlspecialchars($p['code']).'</strong> '.htmlspecialchars($p['type']).' '.($p['claimed']?'(claimed)':'(unclaimed)').'</li>';
    }
    $prizes_html .= '</ul>';
}
echo json_encode(['success'=>true,'data'=>['loyalty_stamps'=>(int)$row['loyalty_stamps'],'referral_stamps'=>(int)$row['referral_stamps'],'xp'=>$xp,'tier'=>$tier,'xp_percent'=>$percent,'next_threshold'=>$threshold,'prizes_html'=>$prizes_html]]);
?>