<?php
// admin/users.php
require_once __DIR__ . '/../scripts/db.php';
$secret = $_GET['admin_secret'] ?? '';
if ($secret !== $ADMIN_SECRET) { http_response_code(403); echo 'Forbidden'; exit; }

$q = trim($_GET['q'] ?? '');
$param = '%' . $q . '%';
$stmt = $pdo->prepare("SELECT id, name, email, phone, referral_code, created_at FROM users WHERE name LIKE ? OR email LIKE ? OR phone LIKE ? ORDER BY id DESC LIMIT 200");
$stmt->execute([$param, $param, $param]);
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Admin — Users</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-white text-gray-800">
  <div class="max-w-6xl mx-auto p-6">
    <h1 class="text-2xl font-semibold mb-4">Admin — Users</h1>
    <form class="mb-4">
      <input name="q" value="<?=htmlspecialchars($q)?>" placeholder="Search name, email, or phone" class="px-3 py-2 border rounded w-80" />
      <input type="hidden" name="admin_secret" value="<?=htmlspecialchars($secret)?>" />
      <button class="px-3 py-2 bg-[#4A7C59] text-white rounded">Search</button>
    </form>

    <table class="w-full border-collapse text-sm">
      <thead><tr class="text-left text-gray-600"><th class="p-2">ID</th><th>Name</th><th>Email</th><th>Phone</th><th>Referral</th><th>Joined</th><th>Actions</th></tr></thead>
      <tbody>
      <?php foreach($users as $u): ?>
        <tr class="border-t">
          <td class="p-2"><?=htmlspecialchars($u['id'])?></td>
          <td class="p-2"><?=htmlspecialchars($u['name'])?></td>
          <td class="p-2"><?=htmlspecialchars($u['email'])?></td>
          <td class="p-2"><?=htmlspecialchars($u['phone'])?></td>
          <td class="p-2"><?=htmlspecialchars($u['referral_code'])?></td>
          <td class="p-2"><?=htmlspecialchars($u['created_at'])?></td>
          <td class="p-2">
            <?php if (!empty($u['phone'])): 
              // make sure phone is in international format (starts with 62)
              $waPhone = preg_replace('/[^0-9]/','',$u['phone']);
              if (strpos($waPhone, '08') === 0) { $waPhone = '62' . substr($waPhone,1); }
            ?>
              <a class="text-[#355f44]" target="_blank" href="https://wa.me/<?=htmlspecialchars($waPhone)?>">WhatsApp</a>
            <?php endif; ?>
            &nbsp;|&nbsp;
            <a href="user_detail.php?admin_secret=<?=htmlspecialchars($secret)?>&id=<?=htmlspecialchars($u['id'])?>" class="text-gray-600">Details</a>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</body>
</html>
