<?php
require_once __DIR__ . '/../scripts/db.php';
$secret = $_GET['admin_secret'] ?? '';
$code = trim($_GET['code'] ?? '');
if ($secret !== $ADMIN_SECRET) { http_response_code(403); echo 'Forbidden'; exit; }
if (!$code) { http_response_code(400); echo 'Provide code'; exit; }

$stmt = $pdo->prepare("SELECT * FROM order_codes WHERE code = ? LIMIT 1");
$stmt->execute([$code]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$row) { http_response_code(404); echo 'Code not found'; exit; }
if (!empty($row['used_by'])) { http_response_code(400); echo 'Code already used'; exit; }

// you (admin) redeem it for a customer: optionally pass user_id via GET? For now mark used_by = 0 to indicate admin redemption
$stmt = $pdo->prepare("UPDATE order_codes SET used_by = 0, used_at = NOW() WHERE id = ?");
$stmt->execute([$row['id']]);

echo "Code {$code} redeemed. Category: {$row['category']}. Meta: {$row['meta']}";
