<?php
// admin/generate_codes.php
declare(strict_types=1);
require_once __DIR__ . '/../scripts/db.php';
date_default_timezone_set('Asia/Jakarta');

$secret = $_GET['admin_secret'] ?? '';
if ($secret !== 'hoki') {
    http_response_code(403);
    echo 'unauthorized';
    exit;
}
$n = min(500, max(1, (int)($_GET['n'] ?? 30)));
$chars = 'ABCDEFGHJKMNPQRSTUVWXYZ23456789';
$tz = new DateTimeZone('Asia/Jakarta');
$today = (new DateTime('now', $tz))->format('Y-m-d');
$created = [];
for ($i=0;$i<$n;$i++) {
    $tries = 0;
    do {
        $prefix = '';
        for ($k=0;$k<3;$k++) $prefix .= $chars[random_int(0, strlen($chars)-1)];
        $day = (new DateTime('now', $tz))->format('d');
        $monthLetter = strtoupper((new DateTime('now', $tz))->format('M')[0]);
        $code = $prefix . $day . $monthLetter;
        $chk = $pdo->prepare('SELECT id FROM order_codes WHERE code = :c LIMIT 1');
        $chk->execute([':c'=>$code]);
        $exists = $chk->fetchColumn();
        $tries++;
        if ($tries > 500) break;
    } while ($exists);
    if ($tries > 500) break;
    $ins = $pdo->prepare('INSERT INTO order_codes (code, valid_date) VALUES (:code, :vd)');
    $ins->execute([':code'=>$code, ':vd'=>$today]);
    $created[] = $code;
}
header('Content-Type: text/plain');
echo "Created " . count($created) . " codes for $today\n";
echo implode("\n", $created);
?>