<?php
// account_backend.php - load user state for account page
require_once __DIR__ . '/scripts/db.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header('Location: /auth/login.php');
    exit;
}

$uid = (int) $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT id, email, name, phone, referral_code, signup_referral_code, referred_by, referral_stamps, loyalty_stamps, xp, tier, cycle_bonus_classic_used, cycle_bonus_ceremonial_used, guarantee_counter, last_cycle_reset_at FROM users WHERE id = :uid");
$stmt->execute([':uid' => $uid]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    die('User not found');
}

$xp = (int)$user['xp'];
$tier = $user['tier'] ?? 'first';
$nextTier = null;
$xpNeeded = 0;
switch ($tier) {
    case 'first':
        $nextTier = 'classic';
        $xpNeeded = 100;
        break;
    case 'classic':
        $nextTier = 'ceremonial';
        $xpNeeded = 500;
        break;
    case 'ceremonial':
    default:
        $nextTier = null;
        $xpNeeded = 0;
        break;
}

$xpToNext = ($nextTier ? max(0, $xpNeeded - $xp) : 0);

$stmt = $pdo->prepare("SELECT id, code, type, claimed, claimed_at, created_at FROM prize_codes WHERE user_id = :uid ORDER BY created_at DESC");
$stmt->execute([':uid' => $uid]);
$prizes = $stmt->fetchAll(PDO::FETCH_ASSOC);

// variables available to template: $user, $xp, $xpToNext, $prizes
?>